﻿

#try{
    #set-ExecutionPolicy remotesigned -Scope CurrentUser -force
#}
#catch {
    #Do Nothing
#}


##encodage utf8
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$PSStyle.Progress.Style

function Green
{
    process { Write-Host $_ -ForegroundColor Green }
}

function Red
{
    process { Write-Host $_ -ForegroundColor Red }

}

function Yellow
{
    process { Write-Host $_ -ForegroundColor Yellow }
}


function Write-ProgressHelper {
	param (
	    [int]$StepNumber,
	    [string]$Message
	)

	Write-Progress -Activity 'RESETTING NETWORK SETTINGS ' -Status $Message  -PercentComplete (($StepNumber / $steps) * 100) -currentoperation "$([int](($StepNumber / $steps) * 100))%"
}

$script:steps = ([System.Management.Automation.PsParser]::Tokenize((gc "$PSScriptRoot\$($MyInvocation.MyCommand.Name)"), [ref]$null) | where { $_.Type -eq 'Command' -and $_.Content -eq 'Write-ProgressHelper' }).Count

$stepCounter = 0

Write-ProgressHelper -Message 'CHECKING IF HEREDIS IS CONNECTED TO YOUR NETWORK' -StepNumber ($stepCounter++)
Start-Sleep -Seconds 5
#verification connexion à Internet

$ProgressPreference = "silentlyContinue"

if ((( tnc -ComputerName www.google.com -WarningAction SilentlyContinue ).pingsucceeded) -and

((tnc -ComputerName www.google.com -WarningAction SilentlyContinue ).pingreplydetails.RoundTripTime  ) -lt 160 )

{
$progresspreference = "Continue"
# script 1 msg + task kill h22 si ouvert
        taskkill /IM "Heredis22.exe" /F >$null 2>&1
        taskkill /IM "Heredis2022.exe" /F >$null 2>&1
        taskkill /IM "Heredis23.exe" /F >$null 2>&1
        taskkill /IM "Heredis2023.exe" /F >$null 2>&1
        taskkill /IM "Heredis24.exe" /F >$null 2>&1
        taskkill /IM "Heredis2024.exe" /F >$null 2>&1
        #taskkill /IM "Heredis22.exe" /F --quiet --no-verbose >$null 2>&1
Write-ProgressHelper -Message 'WORK IN PROGRESS....' -StepNumber ($stepCounter++)
Start-Sleep -Seconds 5
####
#s ipconfig etape 1

        cmd.exe /C ipconfig/release | Out-Null

Write-ProgressHelper -Message 'STEP 1/5.....' -StepNumber ($stepCounter++)
Start-Sleep -Seconds 5

#ipconfig etape 2

        cmd.exe /C ipconfig/renew | Out-Null

Write-ProgressHelper -Message 'STEP 2/5.....' -StepNumber ($stepCounter++)
Start-Sleep -Seconds 5


#ipconfig etape 3
        Clear-DnsClientCache | Out-Null
      
Write-ProgressHelper -Message 'STEP 3/5.....' -StepNumber ($stepCounter++)
Start-Sleep -Seconds 5

#ipconfig etape 4
        Register-DnsClient | Out-Null
      
Write-ProgressHelper -Message 'STEP 4/5...... ' -StepNumber ($stepCounter++)
Start-Sleep -Seconds 5

#ipconfig etape 5
      cmd.exe /C netsh winsock reset | Out-Null

Write-ProgressHelper -Message 'STEP 5/5.......' -StepNumber ($stepCounter++)
Start-Sleep -Seconds 5


Write-Output "
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

STEP 1 OF THE LOCAL SHARING RESET PROCEDURE = OK
THE INTERNET CONNECTION ON THE TARGET MACHINE HAS BEEN RESET.... 
YOU CAN PROCEED TO STEP 2 OF THE PROCEDURE ....  

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::" | Green ;


Write-ProgressHelper -Message 'END OF THES PROCEDURE' -StepNumber(8) -percentcomplete 100

#Set-ExecutionPolicy default -Force -scope CurrentUser

Start-Sleep -Seconds 10
} 




elseif ((( tnc -ComputerName www.google.com  -WarningAction SilentlyContinue ).pingsucceeded ) -and

((tnc -ComputerName www.google.com -WarningAction SilentlyContinue ).pingreplydetails.RoundTripTime  ) -ge 160 )

{

write-output "
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

WARNING!!! YOUR INTERNET CONNECTION IS TOO WEAK OR UNSTABLE TO ALLOW SHARING.
THIS FEATURE WILL THEREFORE NOT BE AVAILABLE ON YOUR SYSTEM ... 
PLEASE REFER TO THE OTHER WAYS TO TRANSFER FILES ON OUR TECHNICAL FAQ 
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::"| Yellow ;

Start-Sleep -Seconds 20

}

else
{

write-output "
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

WARNING!!! YOUR COMPUTER IS NOT CONNECTED TO THE INTERNET OR
THERE IS A PROBLEM WITH YOUR SYSTEM OR YOUR NETWORK CONNECTION!
CONNECT IT TO THE INTERNET AND TRY TO SHARE YOUR FILE AGAIN ... 


::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::"| Red ;

Start-Sleep -Seconds 20

}