﻿
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$PSStyle.Progress.Style

function Green
{
    process { Write-Host $_ -ForegroundColor Green }
}

function Red
{
    process { Write-Host $_ -ForegroundColor Red }

}

function Yellow
{
    process { Write-Host $_ -ForegroundColor Yellow }
}




#try{
    #set-ExecutionPolicy remotesigned -Scope CurrentUser -force
#}
#catch {
    #Do Nothing
#}

#creation du repertoire diag (hidden)
#new-item -Path ".\" -Name "diag" -ItemType "directory"
#(get-item -Path ".\diag" -Force).Attributes -= 'Hidden'

 IF(Test-Path -path .\diag -PathType Container)
      
      {
      #supppression des fichiers et dossiers dans diag
      Get-ChildItem -Path .\diag\*.* -Recurse | Remove-Item -force -recurse;
      Remove-Item -Path .\diag\* -Force ;
      #Remove-Item -Path .\diag\*.*;
      attrib +s +h diag | Out-Null }
      #Set-ItemProperty -Path .\diag -Name Attributes -Value Hidden}
      #(get-item -Path ".\diag" -Force).Attributes -= 'Hidden'} 
      
      else 

      {new-item -Path ".\" -Name "diag" -ItemType "directory" |Out-Null;
       Remove-Item -Path .\diag\*.*;
        attrib +s +h diag | Out-Null }
       #Set-ItemProperty -Path .\diag -Name Attributes -Value Hidden}
       #(get-item -Path ".\diag" -Force).Attributes -= 'Hidden'}



#nettoyage du dossier diag
#Remove-Item -Path .\diag\*.txt
##encodage utf8


function Write-ProgressHelper {
	param (
	    [int]$StepNumber,
	    [string]$Message
	)

	Write-Progress -Activity 'VERIFICATION DES PARAMETRES RESEAUX ' -Status $Message  -PercentComplete (($StepNumber / $steps) * 100) -currentoperation "$([int](($StepNumber / $steps) * 100))%"
}

$script:steps = ([System.Management.Automation.PsParser]::Tokenize((gc "$PSScriptRoot\$($MyInvocation.MyCommand.Name)"), [ref]$null) | where { $_.Type -eq 'Command' -and $_.Content -eq 'Write-ProgressHelper' }).Count

$stepCounter = 0

Write-ProgressHelper -Message 'PREPARATION DES FICHIERS A ECRIRE...' -StepNumber ($stepCounter++)
Start-Sleep -Seconds 5

#verification connexion à Internet
#if(Test-Connection -ComputerName www.google.com -Quiet)
#$Global:progresspreference = "silentlyContinue"

$ProgressPreference = "silentlyContinue"

if ((( tnc -ComputerName www.google.com -WarningAction SilentlyContinue -erroraction SilentlyContinue).pingsucceeded) -and

((tnc -ComputerName www.google.com -WarningAction SilentlyContinue -erroraction SilentlyContinue).pingreplydetails.RoundTripTime  ) -lt 160 )




{

$progresspreference = "Continue"

# script 1 msg + suppression des fichiers zip et txt si déjà présent dans ce dossier
# $PSScriptRoot in PS = $env:p2eincfilepath in PS1TOEXE
    $files = Get-ChildItem -Path "$PSScriptRoot" -Recurse -Include *.zip,*.txt
    foreach ($file in $files)
    {

     del $file -Force
    }

Write-ProgressHelper -Message 'TEST VITESSE CONNEXION...' -StepNumber ($stepCounter++)
Start-Sleep -Seconds 5




#####################################################################################################

#script 2 does a speedcheck 

$DateLog = Get-Date -Format "dd/MM/yyyy HH:mm K"
$datePrefix = Get-Date -Format "yyyyMM_"
$DownloadLocation = "$PSScriptRoot"
$SpeedTestTxt = $DownloadLocation + "\" + $datePrefix + "speedtest_history.txt"
#$SpeedTestTxt = $DownloadLocation + "\" + "speedtest_history.txt"

$ProgressPreference = "silentlyContinue"
#conhost --headless
$SpeedtestResults = &  "$($DownloadLocation)\speedtest.exe" --format=json #--accept-license --accept-gdpr 
$SpeedtestResults = $SpeedtestResults | ConvertFrom-Json 

[PSCustomObject]$SpeedtestObj = @{
    downloadspeed = [math]::Round($SpeedtestResults.download.bandwidth / 1000000 * 8, 2)
    uploadspeed   = [math]::Round($SpeedtestResults.upload.bandwidth / 1000000 * 8, 2)
    packetloss    = [math]::Round($SpeedtestResults.packetLoss)
    isp           = $SpeedtestResults.isp
    ExternalIP    = $SpeedtestResults.interface.externalIp
    InternalIP    = $SpeedtestResults.interface.internalIp
    UsedServer    = $SpeedtestResults.server.host
    ResultsURL    = $SpeedtestResults.result.url
    Jitter        = [math]::Round($SpeedtestResults.ping.jitter)
    Latency       = [math]::Round($SpeedtestResults.ping.latency)
}

$PublicIP = $SpeedtestObj.ExternalIP
$SpeedTestResultDownload = $SpeedtestObj.downloadspeed
$SpeedTestResultDownload = "{0:#,##0.00;(#,##0.00);ERREUR}" -f $SpeedTestResultDownload
$SpeedTestResultUpload = $SpeedtestObj.uploadspeed
$SpeedTestResultUpload = "{0:#,##0.00;(#,##0.00);ERREUR}" -f $SpeedTestResultUpload
$SpeedTestResultLatency = $SpeedtestObj.Latency
$SpeedTestResultLossPk = ($SpeedtestObj.packetloss).tostring("P")
$SpeedTestResultISP = $SpeedtestObj.isp
$SpeedTestResultServer = $SpeedtestObj.UsedServer
$SpeedTestResultServerId = $SpeedtestResults.server.id
$SpeedTestResultServerId1 = "{0:00000}" -f $SpeedTestResultServerId
$SpeedTestResultServerLocation = $SpeedtestResults.server.location

"$DateLog`t   DL: $SpeedTestResultDownload`tMbps   UL: $SpeedTestResultUpload`tMbps   PING: $SpeedTestResultLatency`tms   LOSS: $SpeedTestResultLossPk   ISP: $PublicIP ($SpeedTestResultISP)   SERVER: $SpeedTestResultServerLocation ; id = $SpeedTestResultServerId1 ($SpeedTestResultServer)" | Out-File -Append -Encoding ascii -FilePath $SpeedTestTxt

$progresspreference = "Continue"

# masque le fichier txt
Start-Sleep -Seconds 25
move-item -Path "$PSScriptRoot\*speedtest_history.txt" -Destination ".\diag"
#(get-item -Path $PSScriptRoot\speedtest_history.txt -Force).Attributes += 'Hidden'



#####################################################################################################
## Ps script 3 = verif connexion serveurs google 
      
       Write-ProgressHelper -Message 'VERIFICATION ACCES GOOGLE...' -StepNumber ($stepCounter++)
Start-Sleep -Seconds 5

      
      Test-Connection -ComputerName www.google.com -Count 6 -WarningAction SilentlyContinue -erroraction SilentlyContinue | Format-Table -AutoSize | Out-File -FilePath .\Qu_reseau.txt | 
      #hides generated txt file
      Start-Sleep -Seconds 15
      move-item -Path ".\Qu_reseau.txt" -Destination ".\diag"
      #(get-item -Path $PSScriptRoot\Qu_reseau.txt -Force).Attributes += 'Hidden'

Write-ProgressHelper -Message 'VERIFICATION ACCES HEREDIS ONLINE... ' -StepNumber ($stepCounter++)

Start-Sleep -Seconds 5

## verif connexion serveurs hol
      Test-Connection -ComputerName online.heredis.com -Count 6  | Format-Table -AutoSize | Out-File -FilePath .\Qu_Hweb.txt
      # masque le fichier txt
      Start-Sleep -Seconds 15
      move-item -Path ".\Qu_Hweb.txt" -Destination ".\diag"
      #(get-item -Path $PSScriptRoot\Qu_Hweb.txt -Force).Attributes += 'Hidden'

Write-ProgressHelper -Message 'TEST TYPE CONNEXION' -StepNumber ($stepCounter++)

Start-Sleep -Seconds 5

## accès au réseau via le port ethernet ou wifi
      Get-NetAdapter -Name * -Physical -WarningAction SilentlyContinue -erroraction SilentlyContinue| Format-Table -AutoSize | Out-File -FilePath .\eth_wifi.txt
      move-item -Path ".\eth_wifi.txt" -Destination ".\diag"
      # masque le fichier txt
      Start-Sleep -Seconds 5
      #(get-item -Path $PSScriptRoot\eth_wifi.txt -Force).Attributes += 'Hidden'

Write-ProgressHelper -Message 'CONFIGURATION CLIENT RESEAU' -StepNumber ($stepCounter++)

Start-Sleep -Seconds 5

## config ip de la machine
      ipconfig /all | Format-Table -AutoSize -WarningAction SilentlyContinue -erroraction SilentlyContinue| Out-File -encoding utf8 -FilePath .\ipconfig.txt 
      Start-Sleep -Seconds 5
      move-item -Path ".\ipconfig.txt" -Destination ".\diag"
      # masque le fichier txt
      #(get-item -Path $PSScriptRoot\ipconfig.txt -Force).Attributes += 'Hidden'

Write-ProgressHelper -Message 'CONFIGURATION IPV4 ' -StepNumber ($stepCounter++)

Start-Sleep -Seconds 5

#connexion ipv4 de la machine
      netsh interface ipv4 show interfaces -WarningAction SilentlyContinue -erroraction SilentlyContinue | Format-Table -AutoSize | Out-File -encoding utf8 -FilePath .\ipv4_int.txt
       # masque le fichier txt
       Start-Sleep -Seconds 5
        move-item -Path ".\ipv4_int.txt" -Destination ".\diag"
      #(get-item -Path $PSScriptRoot\ipv4_int.txt -Force).Attributes += 'Hidden'

Write-ProgressHelper -Message 'STATUT WI-FI' -StepNumber ($stepCounter++)


Start-Sleep -Seconds 5

#verif etat de connexion oui/non au wifi 
      netsh wlan show interfaces -WarningAction SilentlyContinue -erroraction SilentlyContinue | Format-Table -AutoSize | Out-File -encoding utf8 -FilePath .\wifi_status.txt
       # masque le fichier txt
       Start-Sleep -Seconds 5
       move-item -Path ".\wifi_status.txt" -Destination ".\diag"
      #(get-item -Path $PSScriptRoot\wifi_status.txt -Force).Attributes += 'Hidden'

Write-ProgressHelper -Message 'ETATS PORTS ENTRANTS ' -StepNumber ($stepCounter++)

Start-Sleep -Seconds 5

#impressions des tables de routages pour les ports (listen)
      route print 2> $null | Format-Table -AutoSize | Out-File -encoding utf8 -FilePath .\listen.txt 
       # masque le fichier txt
       Start-Sleep -Seconds 10
       move-item -Path ".\listen.txt" -Destination ".\diag"
      #(get-item -Path $PSScriptRoot\listen.txt -Force).Attributes += 'Hidden'

Write-ProgressHelper -Message 'COMPRESSION ZIP EN COURS  ' -StepNumber ($stepCounter++)

Start-Sleep -Seconds 10
# verification zip et compression 
$OriginalPref = $ProgressPreference # Default is 'Continue'
$global:ProgressPreference = "SilentlyContinue"

      Get-ChildItem -Path .\diag\*.txt  | Compress-Archive -DestinationPath .\Verif_partage.zip -force -WarningAction SilentlyContinue -erroraction SilentlyContinue

Start-Sleep -Seconds 10
 $ProgressPreference = $OriginalPref

       Remove-Item -Path .\diag\*.txt

      #Compress-Archive $PSScriptRoot\*.txt Verif_partage.zip  
      #IF(Test-Path -path $PSScriptRoot\Verif_partage.zip)
      #{del *.txt} #else 
      #{Start-Sleep -Seconds 5 ; Compress-Archive $PSScriptRoot\*.txt Verif_partage.zip ;del *.txt
 

Write-Output "
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

VOTRE CONNEXION A INTERNET SEMBLE FONCTIONNER CORRECTEMENT...  
UNE ARCHIVE ZIP CONTENANT UN RAPPORT A ETE GENERE DANS LE DOSSIER OU SE TROUVE LE SCRIPT ....
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
IL VOUS FAUT NOUS RETOURNER CETTE ARCHIVE ZIP EN REPONDANT AU DERNIER MAIL 
QUE VOUS AVEZ RECU DU SUPPORT HEREDIS  .... 

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::" | Green ;


Write-ProgressHelper -Message 'FIN DE LA PROCEDURE' -StepNumber(11) -percentcomplete 100

#Set-ExecutionPolicy default -Force -scope CurrentUser

Start-Sleep -Seconds 10
} 


elseif ((( tnc -ComputerName www.google.com  -WarningAction SilentlyContinue -erroraction SilentlyContinue).pingsucceeded ) -and

((tnc -ComputerName www.google.com -WarningAction SilentlyContinue -erroraction SilentlyContinue ).pingreplydetails.RoundTripTime  ) -ge 160 )

{

write-output "
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

ATTENTION !!! VOTRE CONNEXION A INTERNET EST TROP FAIBLE POUR PERMETTRE LE PARTAGE. 
CETTE FONCTION NE SERA DONC PAS DISPONIBLE SUR VOTRE SYSTEME ... 
RENDEZ-VOUS SUR HEREDIS.ZENDESK.COM POUR CONSULTER LES AUTRES METHODES D'ENVOI DE FICHIERS

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::"| Yellow ;

Start-Sleep -Seconds 20

}



else
{

write-output "
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::


ATTENTION !!! VOTRE ORDINATEUR N'EST PAS CONNECTE A INTERNET!!
 CONNECTEZ-LE A INTERNET ET TENTEZ D'EFFECTUER LE PARTAGE DE VOTRE FICHIER A NOUVEAU ... 


::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::"| Red ;

Start-Sleep -Seconds 20

}